/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.mib;

import ibm.nways.jdm.mib.MibModule;
import ibm.nways.jdm.mib.MibValue;
import java.io.Serializable;

public class MibObjectIdentifierValue
extends MibValue
implements Serializable {
    private static final boolean debug = false;
    private String dottedDecimalValue;
    private boolean objectref;
    private String definingModuleName;
    private transient MibModule containingModule;

    public MibObjectIdentifierValue(MibModule mibModule, String string, String string2) {
        this.name = string;
        this.dottedDecimalValue = string2;
        this.definingModuleName = mibModule != null ? mibModule.name : "[unknown]";
        this.containingModule = mibModule;
        this.objectref = false;
    }

    public MibObjectIdentifierValue(MibModule mibModule) {
        this.name = null;
        this.dottedDecimalValue = null;
        this.definingModuleName = mibModule.name;
        this.containingModule = mibModule;
        this.objectref = false;
    }

    public String getValue() {
        this.resolve();
        return this.dottedDecimalValue;
    }

    public boolean hasCorrespondingObject() {
        return this.objectref;
    }

    public void correspondingObject(boolean bl) {
        this.objectref = bl;
    }

    public String getModuleName() {
        return this.definingModuleName;
    }

    protected void resolve() {
        try {
            if (!this.isResolved()) {
                MibModule mibModule;
                String string = "";
                MibValue mibValue = null;
                int n = this.dottedDecimalValue.indexOf(46);
                int n2 = this.dottedDecimalValue.indexOf(58);
                if (n2 > 0) {
                    string = new String(this.dottedDecimalValue.substring(0, n2));
                } else {
                    n2 = -1;
                }
                String string2 = n >= 0 ? new String(this.dottedDecimalValue.substring(n2 + 1, n)) : this.dottedDecimalValue;
                if (n2 > 0) {
                    mibModule = (MibModule)this.containingModule.metadata.modules.get(string);
                    if (mibModule == null && string.endsWith("-v1")) {
                        string = string.substring(0, string.length() - 3);
                        this.dottedDecimalValue = new String(String.valueOf(string) + this.dottedDecimalValue.substring(n2));
                        mibModule = (MibModule)this.containingModule.metadata.modules.get(string);
                        n2 -= 3;
                        n -= 3;
                    }
                } else {
                    mibModule = this.containingModule;
                }
                if (mibModule != null && (mibValue = mibModule.getValue(string2)) != null && mibValue instanceof MibObjectIdentifierValue) {
                    MibObjectIdentifierValue mibObjectIdentifierValue = (MibObjectIdentifierValue)mibValue;
                    if (n > 0) {
                        String string3 = new String(this.dottedDecimalValue.substring(n));
                        this.dottedDecimalValue = new String(String.valueOf(mibObjectIdentifierValue.getValue()) + string3);
                        return;
                    }
                    System.err.println("Internal Error: refindex <= 0 for OI " + this.dottedDecimalValue);
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void putValue(String string) {
        this.dottedDecimalValue = string;
    }

    public String toString() {
        return this.getValue();
    }

    public boolean isResolved() {
        if (this.dottedDecimalValue == null) {
            return false;
        }
        return Character.isDigit(this.dottedDecimalValue.charAt(0));
    }
}

